
 
; Noise source
; 31 bit shift register random generator XOR Q31 and Q28

; Quoted from XILINX application  XAPP 052 July 7,1996 (Version 1.1)

;"An n-bit LFSR counter can have a maximum sequence
;length of 2n-1. In that case, it goes through all possible
;code permutations except one, which would be a lock-up
;state. A maximum length n-bit LFSR counter consists of an
;n-bit shift register with an XNOR in the feedback path from
;the last output Qn to the first input D1. The XNOR makes
;the lock-up state the all-ones state; an XOR would make it
;the all-zeros state. For normal Xilinx applications, all-ones
;is more easily avoided, since by default the flip-flops wake
;up in the all-zeros state. Table 3 describes the outputs that
;must be used as inputs of the XNOR. LFSR outputs are traditionally
;labeled 1 through n, with 1 being the first stage of
;the shift register, and n being the last stage. This is different
;from the conventional 0 to (n-1) notation for binary
;counters."


	ERRORLEVEL -302
	ERRORLEVEL -306

	    list      p=12F617            ; list directive to define processor
     #include <p12F617.inc>        ; processor specific variable definitions


     __CONFIG   _CP_OFF & _BOR_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _IOSCFS_8MHZ & _WRT_OFF

; RAM 
NOISE0		equ	H'20'		; ms byte of shift register
NOISE1		equ	H'21'		; next byte of shift register
NOISE2		equ	H'22'		; next byte of shift register
NOISE3		equ	H'23'		; ls byte of shift register
STORE		equ	H'24'		; storage value

; ******************************************************************

; start at memory 0

	org		0			; reset vector
		
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
        movlw   0x00      			 ; set oscillator to factory calibrated frequency 
        movwf   OSCTUNE
	bcf		STATUS,RP0
; set inputs/outputs
	movlw	B'00000000'
	movwf	GPIO			; ports low
	movlw	B'00000111'		; comparators off
	movwf	CMCON0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'		;  WPU
	movwf	WPU
	movlw	B'00000000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	movlw	B'01000101'		; settings 
	movwf	OPTION_REG

	bcf		STATUS,RP0	; select memory bank 0

;  initial states
; preload shift registers
	movlw	H'11'
	movwf	NOISE0
	movlw	H'8A'
	movwf	NOISE1
	movlw	H'9F'
	movwf	NOISE2
	movlw	H'01'
	movwf	NOISE3

RND ; Output at GPIO,0 only; 
;generate random output (note: Using bit labelling 1-31 (rather than 0 to 30 for software), take 1 from Q value if counter labelling required
	rlf		NOISE0,w		; move Q31 to ms bit 
	movwf	STORE			; store value for xoring with Q28
; place bit 31 to GPIO,0
	rlf		STORE,w		; get carry (bit 31)
	rlf		GPIO,f			; carry to bit 0 GPIO
; get Q28
	swapf	NOISE0,w		; Q28 to ms bit
; both store and w have required Q31 and Q28 in ms bit
	xorwf	STORE,f			; xor Q31 and Q28
	rlf		STORE,w		; move xored value to carry
; move shift register values along 1
	rlf		NOISE3,f		; carry to ls byte	
	rlf		NOISE2,f		; carry to next byte
	rlf		NOISE1,f		; carry to next byte
	rlf		NOISE0,f		; carry to ms byte

	goto	RND			; total 13 clock cycles (6.5us) per half frequency generation

; 2 to the power of 31 -1 results = 2,147,483,647
; clock is 2MHz so 13 cycles is 153.8451kHz generating max frequency of 76.923kHz 
; minimum frequency is 76.923kHz/ 2,147,483,647 = 35.83uHz
; sequence repeats after 13us x 2,147,483,647 = 27,917,280s or 7.75hours


	end
